# pjots_zen_tools/core/theming.py
import os
from .qt_compat import QtWidgets

_DEF_QSS = "zen_base.qss"

def _style_path(name: str) -> str:
    here = os.path.dirname(__file__)
    return os.path.join(here, "ui", "styles", name)

def load_qss(name: str = _DEF_QSS) -> str:
    """Liest ein QSS-File ein (oder gibt '' bei Fehler)."""
    path = _style_path(name)
    try:
        with open(path, "r", encoding="utf-8") as f:
            return f.read()
    except Exception:
        return ""

def apply_styles(root_widget: QtWidgets.QWidget, name: str = _DEF_QSS) -> None:
    """
    Scoped Styling: hängt das QSS NUR an root_widget (und dessen Kinder).
    Beeinflusst Maya-UI nicht.
    """
    if not root_widget:
        return
    qss = load_qss(name)
    if not qss:
        return
    root_widget.setStyleSheet(qss)

# ---- Legacy (nur falls irgendwo noch genutzt) ----
_APPLIED_GLOBAL = False
def apply_global_styles(name: str = _DEF_QSS) -> None:
    """Global (App-weit) – NICHT empfohlen. Bleibt für Backwards-Compat."""
    global _APPLIED_GLOBAL
    if _APPLIED_GLOBAL:
        return
    app = QtWidgets.QApplication.instance()
    if not app:
        return
    qss = load_qss(name)
    if not qss:
        return
    app.setStyleSheet(qss)
    _APPLIED_GLOBAL = True
