import maya.cmds as cmds
from maya import OpenMayaUI as omui
from .qt_compat import QtWidgets, wrapInstance

def dock_widget(name, widget_cls):
    ctrl = f"{name}WorkspaceControl"
    if cmds.workspaceControl(ctrl, q=True, exists=True):
        cmds.deleteUI(ctrl)
    cmds.workspaceControl(ctrl, label=name, retain=False, floating=True, widthProperty=True, initialWidth=420)
    ptr = omui.MQtUtil.findControl(ctrl)
    parent = wrapInstance(int(ptr), QtWidgets.QWidget)
    if parent.layout() is None:
        lay = QtWidgets.QVBoxLayout(parent); lay.setContentsMargins(0,0,0,0)
    w = widget_cls(parent=parent)
    parent.layout().addWidget(w)
    cmds.workspaceControl(ctrl, e=True, visible=True)
